# AI Chat with Image Generation - Content Creator Agent

## Overview
The AI Chat system now supports automatic image generation for the **CONTENT_CREATOR** agent type. When a content creator agent generates text responses, it also:
1. Creates an image prompt based on the generated content
2. Generates an image using Pollinations.ai (free, open-source)
3. Returns both text and image in the response

## How It Works

### Backend Flow (AIChatController.php)
1. User sends a message to a CONTENT_CREATOR agent
2. AI generates text response (via OpenAI or Groq)
3. System automatically creates an image prompt from the text
4. Image is generated using Pollinations.ai API
5. Image is saved to `storage/app/public/ai-images/`
6. Response includes both text and image URL

### Image Generation Service
- **Provider**: Pollinations.ai
- **Cost**: Free, unlimited
- **API**: No API key required
- **URL Format**: `https://image.pollinations.ai/prompt/{encoded_prompt}`

## Setup Instructions

### 1. Ensure Storage Link Exists
```bash
cd laravel-backend
php artisan storage:link
```

### 2. Create AI Agent (Content Creator)
Navigate to: `/ai-agents/create`

Fill in:
- **Name**: e.g., "Social Media Content Creator"
- **Type**: Select "CONTENT_CREATOR"
- **Prompt**: e.g., "You are a creative social media content creator. Generate engaging posts for Instagram, Facebook, and Twitter."
- **Model**: Choose your preferred model (gpt-4, gpt-3.5-turbo, llama-3.1-70b-versatile, etc.)

### 3. Use AI Chat
Navigate to: `/ai-chat`

1. Enter your OpenAI or Groq API key
2. Select provider (OpenAI or Groq)
3. Click on your Content Creator agent
4. Send a message like: "Create a post about healthy eating"

### 4. Response Format
The agent will return:
- **Text Response**: The generated social media post
- **Image Prompt**: A description used to generate the image
- **Generated Image**: Visual content matching the post

## Example Usage

### Input Message:
```
Create an Instagram post about morning coffee
```

### AI Response:
```
☕ Start your day right! There's nothing quite like that first sip of morning coffee. 
The aroma, the warmth, the energy boost - it's the perfect way to kickstart your day. 
What's your favorite coffee blend? 

#MorningCoffee #CoffeeLovers #MorningRoutine #CoffeeTime
```

### Image Prompt Generated:
```
A cozy morning scene with a steaming cup of coffee on a wooden table, 
soft morning sunlight streaming through a window, warm and inviting atmosphere
```

### Generated Image:
An AI-generated image matching the description, saved and displayed in the chat.

## Technical Details

### Storage Location
- **Path**: `storage/app/public/ai-images/`
- **Public URL**: `/storage/ai-images/generated_[timestamp].png`
- **Format**: PNG

### API Endpoints

#### POST `/ai-chat/send`
**Request:**
```json
{
  "agent_id": 1,
  "message": "Create a post about fitness",
  "api_key": "your-api-key",
  "provider": "openai"
}
```

**Response (for CONTENT_CREATOR):**
```json
{
  "response": "Generated text content...",
  "image_url": "/storage/ai-images/generated_1234567890.png",
  "image_prompt": "Description used for image generation"
}
```

**Response (for other agent types):**
```json
{
  "response": "Generated text content..."
}
```

## Agent Types

| Type | Description | Image Generation |
|------|-------------|------------------|
| CONTENT_CREATOR | Creates social media content | ✅ Yes |
| LEAD_QUALIFIER | Qualifies sales leads | ❌ No |
| CUSTOMER_SUPPORT | Handles customer inquiries | ❌ No |
| SALES_ASSISTANT | Assists with sales | ❌ No |

## Customization

### Change Image Generation Provider
Edit `AIChatController.php` method `generateImageWithStableDiffusion()`:

```php
// Current: Pollinations.ai (free, unlimited)
$imageUrl = "https://image.pollinations.ai/prompt/{$encodedPrompt}";

// Alternative: Other free services
// - Hugging Face Inference API
// - Stability AI (requires API key)
// - DALL-E (requires OpenAI API key)
```

### Modify Image Prompt Generation
Edit the prompt in `AIChatController.php` line ~40:

```php
$imagePromptRequest = "Based on this social media post content, create a SHORT, SIMPLE image description (max 50 words) for an AI image generator. Just describe the visual scene, no explanations:\n\n" . $textResponse;
```

## Troubleshooting

### Images Not Generating
1. Check storage permissions: `chmod -R 775 storage/`
2. Verify storage link: `php artisan storage:link`
3. Check logs: `storage/logs/laravel.log`

### Images Not Displaying
1. Ensure storage link exists: `ls -la public/storage`
2. Check file permissions
3. Verify image URL in browser

### Slow Image Generation
- Pollinations.ai can take 10-30 seconds
- Consider adding a loading indicator
- Timeout is set to 60 seconds

## Future Enhancements

Potential improvements:
- [ ] Multiple image styles (realistic, cartoon, abstract)
- [ ] Image size options (square, portrait, landscape)
- [ ] Image editing capabilities
- [ ] Batch image generation
- [ ] Image history/gallery
- [ ] Custom image prompts from user

## Support

For issues or questions:
1. Check Laravel logs: `storage/logs/laravel.log`
2. Enable debug mode: Set `APP_DEBUG=true` in `.env`
3. Test API manually: Visit `https://image.pollinations.ai/prompt/test` in browser
