# Pipeline & Funnel Builder - Quick Start Guide

## 🚀 Getting Started

The Pipeline & Funnel Builder module is now installed and ready to use!

## ✅ What's Included

- **3 Pre-configured Pipelines**:
  - Sales Pipeline (Default) - 6 stages
  - Customer Onboarding - 5 stages
  - Partnership Development - 6 stages

- **17 Sample Deals** across all pipelines
- **Drag-and-drop Kanban boards**
- **Activity tracking** (notes, calls, emails, meetings, tasks)
- **Analytics and reporting**

## 📍 Access the Module

### View All Pipelines
```
http://127.0.0.1:8000/pipelines
```

### View Kanban Board (Sales Pipeline)
```
http://127.0.0.1:8000/pipelines/1
```

### View All Deals
```
http://127.0.0.1:8000/deals
```

## 🎯 Quick Actions

### 1. View the Kanban Board
1. Go to http://127.0.0.1:8000/pipelines
2. Click "View Board" on any pipeline
3. See deals organized by stage
4. Drag deals between stages

### 2. Create a New Deal
1. Click "New Deal" button
2. Fill in:
   - Deal title
   - Select pipeline and stage
   - Enter value and probability
   - Add contact (optional)
   - Set expected close date
3. Click "Create Deal"

### 3. Track Activities
1. Open any deal
2. Select activity type (note, call, email, meeting, task)
3. Enter description
4. Click "Add Activity"
5. View timeline of all activities

### 4. Mark Deals Won/Lost
1. Open deal details
2. Click "Mark Won" or "Mark Lost"
3. For lost deals, optionally enter reason
4. Deal moves to appropriate stage

### 5. Create Custom Pipeline
1. Go to Pipelines page
2. Click "Create Pipeline"
3. Enter name and description
4. Add custom stages with:
   - Stage name
   - Color
   - Win probability
5. Click "Create Pipeline"

## 📊 Analytics Available

### Pipeline Level
- Total deals count
- Total pipeline value
- Weighted value (value × probability)
- Win rate percentage
- Average deal size

### Stage Level
- Deals count per stage
- Total value per stage
- Average days in stage

### Deal Level
- Days in current stage
- Weighted value
- Activity timeline
- Progress tracking

## 🎨 Kanban Board Features

### Drag and Drop
- Click and hold any deal card
- Drag to different stage column
- Release to drop
- Deal automatically updates

### Deal Cards Show
- Deal title
- Value amount
- Contact name
- Owner avatar
- Days in stage
- Probability bar

### Quick Actions Menu
- View details
- Edit deal
- Mark as won
- Mark as lost

### Search & Filter
- Search by deal title
- Search by contact name
- Filter by pipeline
- Filter by user
- Filter by value range

## 🔐 Permissions

Module access controlled by:
- `pipelines` module permission
- `deals` module permission

Admins have full access by default.

## 💡 Tips

1. **Use Default Pipeline**: Start with the pre-configured Sales Pipeline
2. **Track Everything**: Add activities for all interactions
3. **Update Probabilities**: Keep deal probabilities current
4. **Set Close Dates**: Always set expected close dates
5. **Review Analytics**: Check conversion rates regularly

## 🎓 Common Workflows

### Sales Process
1. Create deal in "Lead" stage
2. Qualify and move to "Qualified"
3. Send proposal, move to "Proposal"
4. Negotiate terms, move to "Negotiation"
5. Close deal, mark as "Won" or "Lost"

### Customer Onboarding
1. New customer in "Welcome" stage
2. Complete setup, move to "Setup"
3. Conduct training, move to "Training"
4. Launch, move to "Go Live"
5. Activate, move to "Active"

### Partnership Development
1. Initial contact made
2. Discovery meeting held
3. Proposal submitted
4. Legal review in progress
5. Agreement signed
6. Partnership active

## 📱 Mobile Support

The Kanban board is responsive and works on:
- Desktop (full drag-drop)
- Tablet (touch drag-drop)
- Mobile (list view recommended)

## 🐛 Troubleshooting

### Drag-drop not working?
- Check browser console for errors
- Ensure JavaScript is enabled
- Try refreshing the page

### Deals not showing?
- Check company_id matches
- Verify user has module access
- Check if deals are in correct pipeline

### Can't create pipeline?
- Ensure user has 'pipelines' module access
- Check all required fields are filled
- Minimum 2 stages required

## 📚 Learn More

See full documentation:
- `PIPELINE_FUNNEL_BUILDER_COMPLETE.md` - Complete implementation details
- `REPOSITORY_GUIDELINES.txt` - General project guidelines

## 🎉 You're Ready!

Start managing your sales pipeline with visual Kanban boards!

**Next Steps**:
1. Explore the sample pipelines
2. Create your first custom deal
3. Track activities and progress
4. Review analytics and insights

Happy selling! 💼
