<?php

namespace App\Http\Controllers;

use App\Models\AIAgent;

class AIAgentController extends Controller
{
    public function index()
    {
        $agents = AIAgent::where('user_id', auth()->id())->paginate(15);
        return view('ai-agents.index', compact('agents'));
    }

    public function create()
    {
        return view('ai-agents.create');
    }

    public function store()
    {
        $validated = request()->validate([
            'name' => 'required|string|max:255',
            'type' => 'required|in:LEAD_QUALIFIER,CONTENT_CREATOR,CUSTOMER_SUPPORT,SALES_ASSISTANT',
            'prompt' => 'required|string',
            'model' => 'nullable|string',
            'is_active' => 'nullable|boolean',
            'settings' => 'nullable|json',
        ]);

        AIAgent::create([
            'user_id' => auth()->id(),
            'name' => $validated['name'],
            'type' => $validated['type'],
            'prompt' => $validated['prompt'],
            'model' => $validated['model'] ?? 'gpt-4',
            'is_active' => $validated['is_active'] ?? true,
            'settings' => $validated['settings'] ?? null,
        ]);

        return redirect()->route('ai-agents.index')->with('success', 'AI Agent created successfully');
    }

    public function show($id)
    {
        $agent = AIAgent::findOrFail($id);
        return view('ai-agents.show', compact('agent'));
    }

    public function edit($id)
    {
        $agent = AIAgent::findOrFail($id);
        return view('ai-agents.edit', compact('agent'));
    }

    public function update($id)
    {
        $agent = AIAgent::findOrFail($id);
        $validated = request()->validate([
            'name' => 'required|string|max:255',
            'type' => 'required|in:LEAD_QUALIFIER,CONTENT_CREATOR,CUSTOMER_SUPPORT,SALES_ASSISTANT',
            'prompt' => 'required|string',
            'model' => 'nullable|string',
            'is_active' => 'nullable|boolean',
            'settings' => 'nullable|json',
        ]);

        $agent->update($validated);

        return redirect()->route('ai-agents.index')->with('success', 'AI Agent updated successfully');
    }

    public function destroy($id)
    {
        $agent = AIAgent::findOrFail($id);
        $agent->delete();
        return redirect()->route('ai-agents.index')->with('success', 'AI Agent deleted successfully');
    }
}
