<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conversation;
use Illuminate\Http\Request;

class ConversationController extends Controller
{
    public function index(Request $request)
    {
        $conversations = Conversation::where('company_id', auth()->user()->company_id)
            ->with(['contact', 'user'])
            ->paginate($request->limit ?? 20);

        return response()->json($conversations);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'contact_id' => 'required|exists:contacts,id',
            'channel' => 'required|string',
            'subject' => 'nullable|string',
            'last_message' => 'nullable|string',
            'status' => 'nullable|in:OPEN,CLOSED,PENDING',
        ]);

        $conversation = Conversation::create([
            ...$validated,
            'company_id' => auth()->user()->company_id,
            'user_id' => auth()->id(),
        ]);

        return response()->json($conversation, 201);
    }

    public function show($id)
    {
        $conversation = Conversation::where('company_id', auth()->user()->company_id)
            ->with(['contact', 'user'])
            ->findOrFail($id);

        return response()->json($conversation);
    }

    public function update(Request $request, $id)
    {
        $conversation = Conversation::where('company_id', auth()->user()->company_id)->findOrFail($id);
        $conversation->update($request->all());

        return response()->json($conversation);
    }

    public function destroy($id)
    {
        Conversation::where('company_id', auth()->user()->company_id)->findOrFail($id)->delete();
        return response()->json(null, 204);
    }
}
