<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Opportunity;
use Illuminate\Http\Request;

class OpportunityController extends Controller
{
    public function index(Request $request)
    {
        $opportunities = Opportunity::where('company_id', auth()->user()->company_id)
            ->with(['contact', 'user'])
            ->paginate($request->limit ?? 20);

        return response()->json($opportunities);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'contact_id' => 'required|exists:contacts,id',
            'title' => 'required|string',
            'description' => 'nullable|string',
            'value' => 'nullable|numeric',
            'stage' => 'nullable|in:PROSPECTING,QUALIFICATION,PROPOSAL,NEGOTIATION,CLOSED_WON,CLOSED_LOST',
            'probability' => 'nullable|integer|min:0|max:100',
            'close_date' => 'nullable|date',
        ]);

        $opportunity = Opportunity::create([
            ...$validated,
            'company_id' => auth()->user()->company_id,
            'user_id' => auth()->id(),
        ]);

        return response()->json($opportunity, 201);
    }

    public function show($id)
    {
        $opportunity = Opportunity::where('company_id', auth()->user()->company_id)
            ->with(['contact', 'user'])
            ->findOrFail($id);

        return response()->json($opportunity);
    }

    public function update(Request $request, $id)
    {
        $opportunity = Opportunity::where('company_id', auth()->user()->company_id)->findOrFail($id);
        $opportunity->update($request->all());

        return response()->json($opportunity);
    }

    public function destroy($id)
    {
        Opportunity::where('company_id', auth()->user()->company_id)->findOrFail($id)->delete();
        return response()->json(null, 204);
    }
}
