<?php

namespace App\Http\Controllers;

use App\Models\CalendarEvent;
use Illuminate\Http\Request;

class CalendarController extends Controller
{
    public function index()
    {
        $events = CalendarEvent::where('user_id', auth()->id())->get();
        return view('calendar.index', compact('events'));
    }

    public function create()
    {
        return view('calendar.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'nullable|string',
            'start_date' => 'required|date',
            'end_date' => 'required|date|after_or_equal:start_date',
            'location' => 'nullable|string',
            'color' => 'nullable|string',
        ]);

        CalendarEvent::create([
            ...$validated,
            'user_id' => auth()->id(),
        ]);

        return redirect()->route('calendar.index')->with('success', 'Event created successfully');
    }

    public function show($id)
    {
        $event = CalendarEvent::findOrFail($id);
        return view('calendar.show', compact('event'));
    }

    public function edit($id)
    {
        $event = CalendarEvent::findOrFail($id);
        return view('calendar.edit', compact('event'));
    }

    public function update(Request $request, $id)
    {
        $event = CalendarEvent::findOrFail($id);

        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'nullable|string',
            'start_date' => 'required|date',
            'end_date' => 'required|date|after_or_equal:start_date',
            'location' => 'nullable|string',
            'color' => 'nullable|string',
        ]);

        $event->update($validated);
        return redirect()->route('calendar.show', $event->id)->with('success', 'Event updated successfully');
    }

    public function destroy($id)
    {
        $event = CalendarEvent::findOrFail($id);
        $event->delete();
        return redirect()->route('calendar.index')->with('success', 'Event deleted successfully');
    }
}
