<?php

namespace App\Http\Controllers;

use App\Models\Contact;
use Illuminate\Http\Request;

class ContactController extends Controller
{
    public function index()
    {
        $contacts = Contact::where('company_id', auth()->user()->company_id)->paginate(15);
        return view('contacts.index', compact('contacts'));
    }

    public function create()
    {
        return view('contacts.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'first_name' => 'required|string',
            'last_name' => 'required|string',
            'email' => 'required|email',
            'phone' => 'nullable|string',
            'job_title' => 'nullable|string',
            'company_name' => 'nullable|string',
            'status' => 'nullable|in:LEAD,PROSPECT,CUSTOMER,INACTIVE',
            'source' => 'nullable|string',
        ]);

        Contact::create([
            ...$validated,
            'company_id' => auth()->user()->company_id,
            'user_id' => auth()->id(),
        ]);

        return redirect()->route('contacts.index')->with('success', 'Contact created successfully');
    }

    public function show(Contact $contact)
    {
        return view('contacts.show', compact('contact'));
    }

    public function edit(Contact $contact)
    {
        return view('contacts.edit', compact('contact'));
    }

    public function update(Request $request, Contact $contact)
    {

        $validated = $request->validate([
            'first_name' => 'required|string',
            'last_name' => 'required|string',
            'email' => 'required|email',
            'phone' => 'nullable|string',
            'job_title' => 'nullable|string',
            'company_name' => 'nullable|string',
            'status' => 'nullable|in:LEAD,PROSPECT,CUSTOMER,INACTIVE',
            'source' => 'nullable|string',
        ]);

        $contact->update($validated);
        return redirect()->route('contacts.show', $contact)->with('success', 'Contact updated successfully');
    }

    public function destroy(Contact $contact)
    {
        $contact->delete();
        return redirect()->route('contacts.index')->with('success', 'Contact deleted successfully');
    }
}
