<?php

namespace App\Http\Controllers;

use App\Models\Contact;
use App\Models\Opportunity;
use App\Models\Campaign;
use App\Models\Activity;

class DashboardController extends Controller
{
    public function index()
    {
        $companyId = auth()->user()->company_id;

        return view('dashboard', [
            'totalContacts' => Contact::where('company_id', $companyId)->count(),
            'openOpportunities' => Opportunity::where('company_id', $companyId)->where('status', 'OPEN')->count(),
            'activeCampaigns' => Campaign::where('company_id', $companyId)->where('status', 'ACTIVE')->count(),
            'pendingTasks' => Activity::whereNull('completed_at')->count(),
            'recentContacts' => Contact::where('company_id', $companyId)->latest()->take(5)->get(),
        ]);
    }
}
