<?php

namespace App\Http\Controllers;

use App\Models\Integration;
use Illuminate\Http\Request;

class IntegrationController extends Controller
{
    public function index()
    {
        $integrations = Integration::orderBy('name')->paginate(20);
        return view('integrations.index', compact('integrations'));
    }

    public function create()
    {
        return view('integrations.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'required|string',
            'category' => 'required|string',
            'provider' => 'required|string',
            'logo' => 'nullable|string',
            'rating' => 'nullable|numeric|min:0|max:5',
            'installs' => 'nullable|integer|min:0',
            'pricing' => 'nullable|string',
            'features' => 'nullable|json',
            'status' => 'required|in:AVAILABLE,UNAVAILABLE,COMING_SOON',
            'is_installed' => 'nullable|boolean',
        ]);

        Integration::create($validated);

        return redirect()->route('integrations.index')->with('success', 'Integration created successfully');
    }

    public function show(Integration $integration)
    {
        return view('integrations.show', compact('integration'));
    }

    public function edit(Integration $integration)
    {
        return view('integrations.edit', compact('integration'));
    }

    public function update(Request $request, Integration $integration)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'required|string',
            'category' => 'required|string',
            'provider' => 'required|string',
            'logo' => 'nullable|string',
            'rating' => 'nullable|numeric|min:0|max:5',
            'installs' => 'nullable|integer|min:0',
            'pricing' => 'nullable|string',
            'features' => 'nullable|json',
            'status' => 'required|in:AVAILABLE,UNAVAILABLE,COMING_SOON',
            'is_installed' => 'nullable|boolean',
        ]);

        $integration->update($validated);

        return redirect()->route('integrations.index')->with('success', 'Integration updated successfully');
    }

    public function destroy(Integration $integration)
    {
        $integration->delete();
        return redirect()->route('integrations.index')->with('success', 'Integration deleted successfully');
    }
}
