<?php

namespace App\Http\Controllers;

use App\Models\MediaFile;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class MediaController extends Controller
{
    public function index()
    {
        $media = MediaFile::latest()->get();
        return view('media.index', compact('media'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'files.*' => 'required|file|mimes:jpg,jpeg,png,gif,mp4,mov,avi|max:51200'
        ]);

        foreach ($request->file('files') as $file) {
            $path = $file->store('media', 'public');
            
            MediaFile::create([
                'filename' => pathinfo($path, PATHINFO_BASENAME),
                'original_name' => $file->getClientOriginalName(),
                'mime_type' => $file->getMimeType(),
                'size' => $file->getSize(),
                'url' => Storage::url($path),
                'uploaded_by' => auth()->user()->name
            ]);
        }

        return redirect()->route('media.index')->with('success', 'Media uploaded successfully');
    }

    public function show(MediaFile $file)
    {
        return view('media.show', compact('file'));
    }
}
