<?php

namespace App\Http\Controllers;

use App\Models\Opportunity;
use Illuminate\Http\Request;

class OpportunityController extends Controller
{
    public function index()
    {
        $opportunities = Opportunity::where('company_id', auth()->user()->company_id)->paginate(15);
        return view('opportunities.index', compact('opportunities'));
    }

    public function create()
    {
        return view('opportunities.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'contact_id' => 'required|exists:contacts,id',
            'title' => 'required|string',
            'description' => 'nullable|string',
            'value' => 'nullable|numeric',
            'stage' => 'nullable|in:PROSPECTING,QUALIFICATION,PROPOSAL,NEGOTIATION,CLOSED_WON,CLOSED_LOST',
            'probability' => 'nullable|integer|min:0|max:100',
        ]);

        Opportunity::create([
            ...$validated,
            'company_id' => auth()->user()->company_id,
            'user_id' => auth()->id(),
        ]);

        return redirect()->route('opportunities.index')->with('success', 'Opportunity created');
    }

    public function show(Opportunity $opportunity)
    {
        return view('opportunities.show', compact('opportunity'));
    }

    public function edit(Opportunity $opportunity)
    {
        return view('opportunities.edit', compact('opportunity'));
    }

    public function update(Request $request, Opportunity $opportunity)
    {
        $opportunity->update($request->all());
        return redirect()->route('opportunities.show', $opportunity)->with('success', 'Opportunity updated');
    }

    public function destroy(Opportunity $opportunity)
    {
        $opportunity->delete();
        return redirect()->route('opportunities.index')->with('success', 'Opportunity deleted');
    }
}
