<?php

namespace App\Http\Controllers\Social;

use App\Http\Controllers\Controller;
use App\Models\SocialAccount;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class FacebookController extends Controller
{
    public function callback(Request $request)
    {
        $code = $request->input('code');

        if (!$code) {
            return redirect(env('FRONTEND_URL', 'http://localhost:3000') . '/integrations?error=no_code');
        }

        try {
            $tokenResponse = Http::get('https://graph.facebook.com/v18.0/oauth/access_token', [
                'client_id' => config('services.facebook.client_id'),
                'client_secret' => config('services.facebook.client_secret'),
                'redirect_uri' => config('services.facebook.redirect'),
                'code' => $code,
            ]);

            if (!$tokenResponse->successful()) {
                return redirect(env('FRONTEND_URL', 'http://localhost:3000') . '/integrations?error=token_failed');
            }

            $accessToken = $tokenResponse->json()['access_token'];

            $profileResponse = Http::get('https://graph.facebook.com/me', [
                'fields' => 'id,name',
                'access_token' => $accessToken,
            ]);

            if (!$profileResponse->successful()) {
                return redirect(env('FRONTEND_URL', 'http://localhost:3000') . '/integrations?error=profile_failed');
            }

            $profile = $profileResponse->json();

            SocialAccount::updateOrCreate(
                [
                    'user_id' => auth()->id(),
                    'platform' => 'FACEBOOK',
                ],
                [
                    'platform_user_id' => $profile['id'],
                    'username' => $profile['name'],
                    'access_token' => $accessToken,
                    'is_active' => true,
                ]
            );

            return redirect(env('FRONTEND_URL', 'http://localhost:3000') . '/integrations?success=facebook');
        } catch (\Exception $e) {
            return redirect(env('FRONTEND_URL', 'http://localhost:3000') . '/integrations?error=' . urlencode($e->getMessage()));
        }
    }
}
