<?php

namespace App\Http\Controllers\Social;

use App\Http\Controllers\Controller;
use App\Models\SocialAccount;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class LinkedInController extends Controller
{
    public function callback(Request $request)
    {
        $code = $request->input('code');
        $state = $request->input('state');

        if (!$code) {
            return redirect(env('FRONTEND_URL', 'http://localhost:3000') . '/integrations?error=no_code');
        }

        try {
            $tokenResponse = Http::asForm()->post('https://www.linkedin.com/oauth/v2/accessToken', [
                'grant_type' => 'authorization_code',
                'code' => $code,
                'redirect_uri' => config('services.linkedin.redirect'),
                'client_id' => config('services.linkedin.client_id'),
                'client_secret' => config('services.linkedin.client_secret'),
            ]);

            if (!$tokenResponse->successful()) {
                return redirect(env('FRONTEND_URL', 'http://localhost:3000') . '/integrations?error=token_failed');
            }

            $accessToken = $tokenResponse->json()['access_token'];

            $profileResponse = Http::withToken($accessToken)
                ->get('https://api.linkedin.com/v2/me');

            if (!$profileResponse->successful()) {
                return redirect(env('FRONTEND_URL', 'http://localhost:3000') . '/integrations?error=profile_failed');
            }

            $profile = $profileResponse->json();

            SocialAccount::updateOrCreate(
                [
                    'user_id' => auth()->id(),
                    'platform' => 'LINKEDIN',
                ],
                [
                    'platform_user_id' => $profile['id'],
                    'username' => $profile['localizedFirstName'] . ' ' . $profile['localizedLastName'],
                    'access_token' => $accessToken,
                    'is_active' => true,
                ]
            );

            return redirect(env('FRONTEND_URL', 'http://localhost:3000') . '/integrations?success=linkedin');
        } catch (\Exception $e) {
            return redirect(env('FRONTEND_URL', 'http://localhost:3000') . '/integrations?error=' . urlencode($e->getMessage()));
        }
    }
}
