<?php

namespace App\Http\Controllers\Social;

use App\Http\Controllers\Controller;
use App\Models\SocialAccount;
use Illuminate\Http\Request;

class SocialAccountController extends Controller
{
    public function index()
    {
        $accounts = SocialAccount::where('user_id', auth()->id())->get();
        return response()->json($accounts);
    }

    public function destroy($id)
    {
        $account = SocialAccount::where('user_id', auth()->id())->findOrFail($id);
        $account->delete();
        return response()->json(['message' => 'Account disconnected successfully']);
    }
}
