<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Module;
use App\Models\UserModuleAccess;
use Illuminate\Http\Request;

class UserAccessController extends Controller
{
    public function index()
    {
        $users = User::where('role', '!=', 'admin')->get();
        return view('user-access.index', compact('users'));
    }

    public function edit($user)
    {
        $user = User::findOrFail($user);
        $modules = Module::orderBy('sort_order')->get();
        $userAccess = $user->moduleAccess()->pluck('access', 'module_id')->toArray();
        
        return view('user-access.edit', compact('user', 'modules', 'userAccess'));
    }

    public function update(Request $request, $user)
    {
        $user = User::findOrFail($user);
        $modules = $request->input('modules', []);
        
        foreach ($modules as $moduleId => $access) {
            UserModuleAccess::updateOrCreate(
                ['user_id' => $user->id, 'module_id' => $moduleId],
                ['access' => $access]
            );
        }

        return redirect()->route('user-access.index')->with('success', 'User access updated successfully');
    }
}
