<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class AdminMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        if (auth()->check() && strtolower(auth()->user()->role) === 'admin') {
            return $next($request);
        }

        abort(403, 'Unauthorized');
    }
}
