<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckModuleAccess
{
    public function handle(Request $request, Closure $next, $module)
    {
        if (auth()->check()) {
            if (auth()->user()->role === 'ADMIN' || strtolower(auth()->user()->role) === 'admin') {
                return $next($request);
            }

            if (auth()->user()->hasModuleAccess($module)) {
                return $next($request);
            }
        }

        abort(403, 'You do not have access to this module');
    }
}
