<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Activity extends Model
{
    protected $fillable = ['contact_id', 'opportunity_id', 'type', 'title', 'description', 'due_date', 'completed_at'];
    protected $casts = ['due_date' => 'datetime', 'completed_at' => 'datetime'];

    public function contact() { return $this->belongsTo(Contact::class); }
    public function opportunity() { return $this->belongsTo(Opportunity::class); }
}
