<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CalendarEvent extends Model
{
    protected $table = 'calendar_events';
    protected $fillable = ['title', 'description', 'start_time', 'end_time', 'location', 'attendees', 'user_id'];
    protected $casts = ['start_time' => 'datetime', 'end_time' => 'datetime', 'attendees' => 'json'];

    public function user() { return $this->belongsTo(User::class); }
}
