<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Campaign extends Model
{
    protected $fillable = ['company_id', 'name', 'type', 'description', 'start_date', 'end_date', 'budget', 'status'];
    protected $casts = ['start_date' => 'datetime', 'end_date' => 'datetime', 'budget' => 'decimal:2'];

    public function company() { return $this->belongsTo(Company::class); }
}
