<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    protected $fillable = ['name', 'domain', 'logo', 'settings', 'plan', 'is_active'];
    protected $casts = ['settings' => 'json', 'is_active' => 'boolean'];

    public function users() { return $this->hasMany(User::class); }
    public function contacts() { return $this->hasMany(Contact::class); }
    public function opportunities() { return $this->hasMany(Opportunity::class); }
    public function socialAccounts() { return $this->hasMany(SocialAccount::class); }
    public function campaigns() { return $this->hasMany(Campaign::class); }
    public function reviews() { return $this->hasMany(Review::class); }
    public function subscriptions() { return $this->hasMany(Subscription::class); }
    public function whiteLabel() { return $this->hasOne(WhiteLabel::class); }
}
