<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\LogsActivity;

class Contact extends Model
{
    use LogsActivity;
    
    protected $fillable = ['company_id', 'user_id', 'first_name', 'last_name', 'email', 'phone', 'job_title', 'company_name', 'status', 'source', 'tags', 'custom_fields'];
    protected $casts = ['tags' => 'json', 'custom_fields' => 'json'];

    public function company() { return $this->belongsTo(Company::class); }
    public function user() { return $this->belongsTo(User::class); }
    public function conversations() { return $this->hasMany(Conversation::class); }
    public function opportunities() { return $this->hasMany(Opportunity::class); }
    public function activities() { return $this->hasMany(Activity::class); }
}
