<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class EmailCampaign extends Model
{
    protected $table = 'email_campaigns';
    protected $fillable = ['user_id', 'email_template_id', 'name', 'subject', 'recipients', 'status', 'sent_at', 'stats', 'smtp_host', 'smtp_port', 'smtp_username', 'smtp_password', 'smtp_encryption', 'from_email', 'from_name'];
    protected $casts = ['recipients' => 'json', 'stats' => 'json', 'sent_at' => 'datetime'];

    public function user() { return $this->belongsTo(User::class); }
    public function template() { return $this->belongsTo(EmailTemplate::class, 'email_template_id'); }
}
