<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GetLateProfile extends Model
{
    protected $table = 'getlate_profiles';
    
    protected $fillable = [
        'user_id',
        'getlate_profile_id',
        'profile_name',
        'connected_platforms',
        'is_active'
    ];

    protected $casts = [
        'connected_platforms' => 'array',
        'is_active' => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
