<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    protected $fillable = ['subscription_id', 'amount', 'currency', 'status', 'due_date', 'paid_at'];
    protected $casts = ['amount' => 'decimal:2', 'due_date' => 'datetime', 'paid_at' => 'datetime'];

    public function subscription() { return $this->belongsTo(Subscription::class); }
}
