<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Message extends Model
{
    protected $fillable = ['conversation_id', 'content', 'sender', 'is_read', 'attachments'];
    protected $casts = ['attachments' => 'json', 'is_read' => 'boolean'];

    public function conversation() { return $this->belongsTo(Conversation::class); }
}
