<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OAuthToken extends Model
    protected $table = 'o_auth_tokens';
    protected $fillable = ['user_id', 'provider', 'provider_id', 'access_token', 'refresh_token', 'expires_at'];
    protected $casts = ['expires_at' => 'datetime'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
