<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Opportunity extends Model
{
    protected $fillable = ['company_id', 'user_id', 'contact_id', 'title', 'description', 'value', 'stage', 'status', 'probability', 'source', 'pipeline', 'assigned_to', 'tags', 'notes', 'engagement_score', 'lost_reason_name', 'metadata', 'expected_close_date', 'actual_close_date'];
    protected $casts = ['tags' => 'json', 'metadata' => 'json', 'expected_close_date' => 'datetime', 'actual_close_date' => 'datetime', 'value' => 'decimal:2'];

    public function company() { return $this->belongsTo(Company::class); }
    public function user() { return $this->belongsTo(User::class); }
    public function contact() { return $this->belongsTo(Contact::class); }
    public function activities() { return $this->hasMany(Activity::class); }
}
