<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pipeline extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'company_id',
        'user_id',
        'name',
        'description',
        'is_default',
        'settings'
    ];

    protected $casts = [
        'is_default' => 'boolean',
        'settings' => 'array',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];

    // Relationships
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function stages()
    {
        return $this->hasMany(PipelineStage::class)->orderBy('order');
    }

    public function deals()
    {
        return $this->hasMany(Deal::class);
    }

    // Scopes
    public function scopeForCompany($query, $companyId)
    {
        return $query->where('company_id', $companyId);
    }

    public function scopeDefault($query)
    {
        return $query->where('is_default', true);
    }

    // Accessors
    public function getTotalValueAttribute()
    {
        return $this->deals()->sum('value');
    }

    public function getDealsCountAttribute()
    {
        return $this->deals()->count();
    }

    public function getWonDealsCountAttribute()
    {
        return $this->deals()->whereNotNull('won_at')->count();
    }

    public function getWonValueAttribute()
    {
        return $this->deals()->whereNotNull('won_at')->sum('value');
    }
}
