<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PipelineStage extends Model
{
    protected $fillable = [
        'pipeline_id',
        'name',
        'color',
        'order',
        'win_probability',
        'automation_rules'
    ];

    protected $casts = [
        'order' => 'integer',
        'win_probability' => 'integer',
        'automation_rules' => 'array',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relationships
    public function pipeline()
    {
        return $this->belongsTo(Pipeline::class);
    }

    public function deals()
    {
        return $this->hasMany(Deal::class, 'stage_id');
    }

    // Accessors
    public function getTotalValueAttribute()
    {
        return $this->deals()->sum('value');
    }

    public function getDealsCountAttribute()
    {
        return $this->deals()->count();
    }

    public function getAverageDaysInStageAttribute()
    {
        $deals = $this->deals;
        if ($deals->isEmpty()) {
            return 0;
        }

        $totalDays = $deals->sum(function ($deal) {
            return $deal->created_at->diffInDays(now());
        });

        return round($totalDays / $deals->count());
    }
}
