<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SocialAccount extends Model
{
    protected $table = 'social_accounts';
    protected $fillable = ['user_id', 'company_id', 'platform', 'platform_user_id', 'account_id', 'username', 'access_token', 'refresh_token', 'expires_at', 'is_active'];
    protected $casts = ['expires_at' => 'datetime', 'is_active' => 'boolean'];

    public function company() { return $this->belongsTo(Company::class); }
    public function posts() { return $this->hasMany(SocialPost::class); }
}
