<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SocialPost extends Model
    protected $table = 'social_posts';
    protected $fillable = ['social_account_id', 'user_id', 'content', 'media_urls', 'platform', 'status', 'scheduled_at', 'published_at', 'engagement'];
    protected $casts = ['media_urls' => 'json', 'engagement' => 'json', 'scheduled_at' => 'datetime', 'published_at' => 'datetime'];

    public function socialAccount() { return $this->belongsTo(SocialAccount::class); }
    public function user() { return $this->belongsTo(User::class); }
}
