<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    protected $fillable = ['company_id', 'plan', 'status', 'current_period_start', 'current_period_end', 'cancel_at_period_end'];
    protected $casts = ['current_period_start' => 'datetime', 'current_period_end' => 'datetime', 'cancel_at_period_end' => 'boolean'];

    public function company() { return $this->belongsTo(Company::class); }
    public function invoices() { return $this->hasMany(Invoice::class); }
}
