<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TeamMessage extends Model
{
    protected $fillable = [
        'team_room_id',
        'user_id',
        'content',
        'type',
        'file_url'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relationships
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function teamRoom()
    {
        return $this->belongsTo(TeamRoom::class);
    }

    // Scopes
    public function scopeForTeamRoom($query, $teamRoomId)
    {
        return $query->where('team_room_id', $teamRoomId);
    }

    public function scopeRecent($query, $limit = 50)
    {
        return $query->orderBy('created_at', 'desc')->limit($limit);
    }
}
