<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TeamRoom extends Model
{
    protected $fillable = [
        'company_id',
        'name',
        'description',
        'type'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relationships
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function messages()
    {
        return $this->hasMany(TeamMessage::class);
    }

    public function members()
    {
        return $this->belongsToMany(User::class, 'team_members', 'team_room_id', 'user_id');
    }
}
