<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use App\Traits\LogsActivity;

class User extends Authenticatable
{
    use HasApiTokens, Notifiable, LogsActivity;

    protected $fillable = ['name', 'email', 'password', 'avatar', 'role', 'company_id', 'is_active', 'occupation', 'phone', 'bio'];
    protected $hidden = ['password'];
    protected $casts = ['is_active' => 'boolean', 'last_login_at' => 'datetime'];

    public function company() { return $this->belongsTo(Company::class); }
    public function contacts() { return $this->hasMany(Contact::class); }
    public function conversations() { return $this->hasMany(Conversation::class); }
    public function opportunities() { return $this->hasMany(Opportunity::class); }
    public function aiAgents() { return $this->hasMany(AIAgent::class); }
    public function socialPosts() { return $this->hasMany(SocialPost::class); }
    public function calendarEvents() { return $this->hasMany(CalendarEvent::class); }
    public function emailCampaigns() { return $this->hasMany(EmailCampaign::class); }
    public function teamMember() { return $this->hasOne(TeamMember::class); }
    public function auditLogs() { return $this->hasMany(AuditLog::class); }
    public function notifications() { return $this->hasMany(Notification::class); }
    public function moduleAccess() { return $this->hasMany(UserModuleAccess::class); }

    public function hasModuleAccess($moduleSlug)
    {
        return $this->moduleAccess()
            ->whereHas('module', fn($q) => $q->where('slug', $moduleSlug))
            ->where('access', 'allowed')
            ->exists();
    }
}
