<?php

namespace App\Services;

use App\Models\Contact;

class ContactService
{
    public function getContacts($companyId, $filters = [])
    {
        $query = Contact::where('company_id', $companyId);

        if (isset($filters['status'])) {
            $query->where('status', $filters['status']);
        }
        if (isset($filters['source'])) {
            $query->where('source', $filters['source']);
        }
        if (isset($filters['tags'])) {
            $query->whereJsonContains('tags', $filters['tags']);
        }

        return $query->paginate($filters['limit'] ?? 20);
    }

    public function createContact($companyId, $userId, $data)
    {
        return Contact::create([
            ...$data,
            'company_id' => $companyId,
            'user_id' => $userId,
        ]);
    }

    public function updateContact($id, $data)
    {
        $contact = Contact::findOrFail($id);
        $contact->update($data);
        return $contact;
    }

    public function deleteContact($id)
    {
        return Contact::destroy($id);
    }

    public function bulkDelete($companyId, $ids)
    {
        return Contact::where('company_id', $companyId)
            ->whereIn('id', $ids)
            ->delete();
    }
}
