<?php

namespace App\Traits;

use App\Models\AuditLog;

trait LogsActivity
{
    public static function bootLogsActivity()
    {
        static::created(function ($model) {
            self::createAuditLog('created', $model);
        });

        static::updated(function ($model) {
            self::createAuditLog('updated', $model);
        });

        static::deleted(function ($model) {
            self::createAuditLog('deleted', $model);
        });
    }

    private static function createAuditLog($action, $model)
    {
        AuditLog::create([
            'user_id' => auth()->id(),
            'action' => $action,
            'resource' => class_basename($model),
            'details' => $model->toArray(),
            'ip_address' => request()->ip(),
            'user_agent' => request()->userAgent(),
        ]);
    }
}
