<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('conversations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies');
            $table->foreignId('contact_id')->constrained('contacts');
            $table->foreignId('user_id')->constrained('users');
            $table->string('channel')->default('email');
            $table->text('subject')->nullable();
            $table->text('last_message')->nullable();
            $table->enum('status', ['OPEN', 'CLOSED', 'PENDING'])->default('OPEN');
            $table->dateTime('last_message_at')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('conversations'); }
};
