<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('opportunities', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies');
            $table->foreignId('user_id')->constrained('users');
            $table->foreignId('contact_id')->constrained('contacts');
            $table->string('title');
            $table->text('description')->nullable();
            $table->decimal('value', 10, 2);
            $table->enum('stage', ['PROSPECTING', 'QUALIFICATION', 'PROPOSAL', 'NEGOTIATION', 'CLOSED_WON', 'CLOSED_LOST'])->default('PROSPECTING');
            $table->enum('status', ['OPEN', 'LOST', 'ABANDONED', 'WON'])->default('OPEN');
            $table->integer('probability')->default(0);
            $table->string('source')->nullable();
            $table->string('pipeline')->nullable();
            $table->string('pipeline_id')->nullable();
            $table->string('pipeline_stage_id')->nullable();
            $table->string('assigned_to')->nullable();
            $table->string('followers')->nullable();
            $table->json('tags')->nullable();
            $table->text('notes')->nullable();
            $table->integer('engagement_score')->default(0);
            $table->string('lost_reason_id')->nullable();
            $table->string('lost_reason_name')->nullable();
            $table->json('metadata')->nullable();
            $table->dateTime('expected_close_date')->nullable();
            $table->dateTime('actual_close_date')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('opportunities'); }
};
