<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('messages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('conversation_id')->constrained('conversations');
            $table->text('content');
            $table->enum('sender', ['USER', 'CONTACT', 'SYSTEM'])->default('USER');
            $table->boolean('is_read')->default(false);
            $table->json('attachments')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('messages'); }
};
