<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('social_posts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('social_account_id')->constrained('social_accounts');
            $table->foreignId('user_id')->constrained('users');
            $table->text('content');
            $table->json('media_urls')->nullable();
            $table->enum('platform', ['LINKEDIN', 'TWITTER', 'FACEBOOK', 'INSTAGRAM', 'TIKTOK']);
            $table->enum('status', ['DRAFT', 'SCHEDULED', 'PUBLISHED', 'FAILED'])->default('DRAFT');
            $table->dateTime('scheduled_at')->nullable();
            $table->dateTime('published_at')->nullable();
            $table->json('engagement')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('social_posts'); }
};
