<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('ai_agents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users');
            $table->string('name');
            $table->enum('type', ['LEAD_QUALIFIER', 'CONTENT_CREATOR', 'CUSTOMER_SUPPORT', 'SALES_ASSISTANT']);
            $table->text('prompt');
            $table->string('model')->default('gpt-4');
            $table->boolean('is_active')->default(true);
            $table->json('settings')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('ai_agents'); }
};
