<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('automation_workflows', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ai_agent_id')->nullable()->constrained('ai_agents');
            $table->string('name');
            $table->text('description')->nullable();
            $table->json('trigger');
            $table->json('actions');
            $table->boolean('is_active')->default(true);
            $table->integer('run_count')->default(0);
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('automation_workflows'); }
};
