<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('email_campaigns', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users');
            $table->foreignId('email_template_id')->constrained('email_templates');
            $table->string('name');
            $table->string('subject');
            $table->json('recipients');
            $table->enum('status', ['DRAFT', 'SCHEDULED', 'SENDING', 'SENT', 'PAUSED'])->default('DRAFT');
            $table->dateTime('sent_at')->nullable();
            $table->json('stats')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('email_campaigns'); }
};
