<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('media_files', function (Blueprint $table) {
            $table->id();
            $table->string('filename');
            $table->string('original_name');
            $table->string('mime_type');
            $table->integer('size');
            $table->string('url');
            $table->string('thumbnail_url')->nullable();
            $table->foreignId('folder_id')->nullable()->constrained('folders');
            $table->string('uploaded_by');
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('media_files'); }
};
