<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies');
            $table->string('plan');
            $table->enum('status', ['ACTIVE', 'CANCELED', 'PAST_DUE', 'UNPAID'])->default('ACTIVE');
            $table->dateTime('current_period_start');
            $table->dateTime('current_period_end');
            $table->boolean('cancel_at_period_end')->default(false);
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('subscriptions'); }
};
