<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('team_rooms', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->enum('type', ['GROUP', 'PRIVATE'])->default('GROUP');
            $table->foreignId('company_id')->constrained('companies');
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('team_rooms'); }
};
