<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('team_members', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users');
            $table->foreignId('team_room_id')->nullable()->constrained('team_rooms');
            $table->enum('role', ['OWNER', 'ADMIN', 'MEMBER', 'VIEWER'])->default('MEMBER');
            $table->json('permissions')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('team_members'); }
};
