<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('white_labels', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->unique()->constrained('companies');
            $table->string('domain')->unique();
            $table->string('logo')->nullable();
            $table->json('colors')->nullable();
            $table->json('settings')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('white_labels'); }
};
